<?php

declare(strict_types=1);

namespace Gls\GlsPoland\AdePlus\Fault;

use Gls\GlsPoland\Soap\Client\Exception\SoapFault;

class AdePlusFault extends SoapFault
{
    /**
     * @return static
     */
    public static function fromParent(SoapFault $fault): self
    {
        $message = sprintf('ADE-Plus error (code: %s): "%s".', $fault->getFaultCode(), $fault->getMessage());

        return new static($message, $fault->getFaultCode(), $fault->getFaultActor(), $fault->getDetail(), $fault);
    }
}
