<?php

declare(strict_types=1);

namespace Gls\GlsPoland\EventListener;

use Gls\GlsPoland\Configuration\Initializer\ConfigurationInitializerInterface;
use Gls\GlsPoland\PrestaShop\Hook\Common\ActionDispatcherBefore;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Symfony\Component\HttpKernel\Event\KernelEvent;
use Symfony\Component\HttpKernel\KernelEvents;

/**
 * @deprecated use {@see ActionDispatcherBefore} instead
 */
final class InitializeConfigurationListener implements EventSubscriberInterface
{
    private $initializers;

    /**
     * @param iterable<ConfigurationInitializerInterface> $initializers
     */
    public function __construct(iterable $initializers)
    {
        $this->initializers = $initializers;
    }

    public static function getSubscribedEvents(): array
    {
        return [
            KernelEvents::REQUEST => ['onKernelRequest', 64],
        ];
    }

    public function onKernelRequest(KernelEvent $event): void
    {
        if (!$event->isMasterRequest()) {
            return;
        }

        foreach ($this->initializers as $initializer) {
            $initializer->init();
        }
    }
}
