<?php

declare(strict_types=1);

namespace Gls\GlsPoland\MessageHandler\Consignment;

use Gls\GlsPoland\AdePlus\Fault\AdePlusFault;
use Gls\GlsPoland\Entity\Consignment;

final class CreateConsignmentsResult
{
    private $consignments;
    private $errors;

    /**
     * @param array<int, Consignment> $consignments
     * @param array<int, AdePlusFault> $errors
     */
    public function __construct(array $consignments, array $errors)
    {
        $this->consignments = $consignments;
        $this->errors = $errors;
    }

    /**
     * @return array<int, Consignment>
     */
    public function getConsignments(): array
    {
        return $this->consignments;
    }

    /**
     * @return array<int, AdePlusFault>
     */
    public function getErrors(): array
    {
        return $this->errors;
    }
}
