<?php

declare(strict_types=1);

namespace Gls\GlsPoland\PrestaShop\Grid\AccessibilityChecker;

use Gls\GlsPoland\Controller\Admin\ConsignmentController;
use PrestaShop\PrestaShop\Core\Grid\Action\Row\AccessibilityChecker\AccessibilityCheckerInterface;
use PrestaShopBundle\Security\Voter\PageVoter;
use Symfony\Component\Security\Core\Authorization\AuthorizationCheckerInterface;

final class DeleteConsignmentAccessibilityChecker implements AccessibilityCheckerInterface
{
    private $authorizationChecker;

    private $authorization;

    public function __construct(AuthorizationCheckerInterface $authorizationChecker)
    {
        $this->authorizationChecker = $authorizationChecker;
    }

    public function isGranted(array $record): bool
    {
        return !isset($record['pickup_id']) && $this->checkAuthorization();
    }

    private function checkAuthorization(): bool
    {
        return $this->authorization ?? ($this->authorization = $this->authorizationChecker->isGranted(PageVoter::DELETE, ConsignmentController::TAB_NAME));
    }
}
