<?php

declare(strict_types=1);

namespace Gls\GlsPoland\Soap\Client\Caller;

use Gls\GlsPoland\Soap\Client\Type\RequestInterface;
use Gls\GlsPoland\Soap\Client\Type\ResultInterface;
use Psr\Log\LoggerInterface;

final class LoggingCaller implements CallerInterface
{
    private $caller;
    private $logger;

    public function __construct(CallerInterface $caller, LoggerInterface $logger)
    {
        $this->caller = $caller;
        $this->logger = $logger;
    }

    public function call(string $method, RequestInterface $request): ResultInterface
    {
        $this->logger->info('SOAP request', [
            'method' => $method,
            'params' => $request,
        ]);

        try {
            $response = $this->caller->call($method, $request);

            $this->logger->info('SOAP response', [
                'response' => $response,
            ]);

            return $response;
        } catch (\Throwable $e) {
            $this->logger->error('SOAP error', [
                'method' => $method,
                'params' => $request,
                'error' => $e,
            ]);

            throw $e;
        }
    }
}
