<?php

declare(strict_types=1);

namespace Gls\GlsPoland\Soap\ExtSoapEngine;

use Gls\GlsPoland\Soap\Engine\Engine;
use Gls\GlsPoland\Soap\Engine\TransportInterface;
use Gls\GlsPoland\Soap\ExtSoapEngine\Transport\ExtSoapClientTransport;

final class ExtSoapEngineFactory
{
    public static function fromOptions(ExtSoapOptions $options): Engine
    {
        $driver = ExtSoapDriver::createFromOptions($options);
        $handler = new ExtSoapClientTransport($driver->getClient());

        return new Engine($driver, $handler);
    }

    public static function fromOptionsWithTransport(ExtSoapOptions $options, TransportInterface $transport): Engine
    {
        $driver = ExtSoapDriver::createFromOptions($options);

        return new Engine($driver, $transport);
    }
}
